'PROJECT: ATMEGA-BASED LCF METER

'Bascom-Avr IDE [2.0.7.5]
'Micro: ATmega8A
'Flash used:3648 Bytes
'Author: Mahmood Alimohammadi
'Date:19 December 2018
'************************************

$regfile = "m8adef.dat"
$crystal = 16000000
'------------------------------------
Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portb.2 , Db5 = Portb.3 , Db6 = Portb.4 , Db7 = Portb.5 , E = Portb.1 , Rs = Portb.0

Config Timer0 = Counter , Edge = Rising
Config Timer1 = Timer , Prescale = 256
'------------------------------------
Config Portd.1 = Input : Portd.1 = 1 : Freq_mode Alias Pind.1
Config Portd.2 = Input : Portd.2 = 1 : Lc_mode Alias Pind.2
Config Portd.3 = Output : Relay Alias Portd.3
Config Portd.4 = Input : Portd.4 = 1
'------------------------------------
Config Single = Scientific , Digits = 2
'------------------------------------
Dim Count As Long : Count = 0
Dim Freq As Single , Freq1 As Single , Freq2 As Single
Dim Lx As Single , Cx As Single , Bar As Byte , C As Word

'------------------------------------
'Bargraph
Deflcdchar 0 , 32 , 32 , 31 , 31 , 31 , 31 , 32 , 32

'Capacitor symbol
Deflcdchar 1 , 32 , 4 , 4 , 31 , 32 , 31 , 4 , 4

'Inductor symbol
Deflcdchar 2 , 32 , 2 , 23 , 23 , 23 , 23 , 23 , 2


'Frequency symbol
Deflcdchar 3 , 28 , 20 , 20 , 20 , 21 , 5 , 5 , 7

'------------------------------------
'Value of inductor L1 in the oscillator circuit
Const L1 = 104

'Value of capacitor C1 in the oscillator circuit
Const C1 = 1200

'Timer1 Constant for 1 second
Const Tvalue = 3035

Timer1 = Tvalue
'------------------------------------
On Timer0 Timer0_overflow
On Timer1 Oscillator

Enable Interrupts
Enable Timer0
Enable Timer1

'************************************
'Beginning of the program


'Set Relay
If Freq_mode = 1 Then Set Relay

'Three seconds needed for calibration
Wait 3
Stop Timer0
Stop Timer1

Freq1 = Freq
Freq1 = Freq1 * Freq1

Cursor Off
Cls

Upperline
Lcd "Ready"

Lowerline
Lcd "Measure..."

Reset Relay

Gosub Timers_reset

Stop
'------------------------------------

Frequency:

'Calculate frequency
C = Counter0
   Freq = Count * 256
   Freq = Freq + C
   Freq2 = Freq

Return
'------------------------------------

'Calculate Lx
Inductance:

Freq2 = Freq2 * Freq2

Lx = Freq1 / Freq2
Lx = Lx - 1
Lx = Lx * L1

If Lx < 0 Then Lx = 0
If Freq < 100 Then Lx = 0

Return
'------------------------------------

'Calculate Cx
Capacitance:

Freq2 = Freq2 * Freq2
Cx = Freq1 / Freq2
Cx = Cx - 1
Cx = Cx * C1

If Cx < 0 Then Cx = 0
If Freq < 100 Then Cx = 0

Return
'------------------------------------

 Displaying:

 Cls
 Cursor Off

'Display bargraph for three seconds During Calibration
If Relay = 1 Then

      Upperline
      Lcd "Calibrating...        "

      For Bar = 1 To 16
      Locate 2 , Bar
      Lcd Chr(0)
      Waitms 80

      Next
'------------------------------------
Else

   'Display LX value.
   If Lc_mode = 0 Then
      Upperline
      Lcd " L: " ; Lx ; " uH          "

      Locate 2 , 8
      Lcd Chr(2 )

      If Lx > 999 Then
         Lx = Lx / 1000
         Upperline
         Lcd " L: " ; Lx ; " mH              "

      End If


   End If
 '-----------------------------------
 'Display CX value

   If Lc_mode = 1 Then
      Cls

      Upperline
      Lcd " C: " ; Cx ; " pF               "

      Locate 2 , 8
      Lcd Chr(1)

      If Cx > 999 Then
         Cx = Cx / 1000

         Upperline

         Lcd " C: " ; Cx ; " nF               "

      End If
   End If
 End If
'------------------------------------
'Display frequency value.

If Freq_mode = 0 Then
   Cls
    Freq = Freq / 1000

   Upperline
   Lcd "F: " ; Freq ; " KHz               "

   Locate 2 , 8
   Lcd Chr(3)


End If

Return
'------------------------------------
Timers_reset:

   Counter0 = 0
   Count = 0
   Start Timer0
   Timer1 = Tvalue
   Start Timer1

Return
   '---------------------------------

Timer0_overflow:

   Incr Count

Return
'------------------------------------
'Calculate frequency
Oscillator:
   Stop Timer0
   Stop Timer1

'Go to Sub Frequency to calculate frequency
Gosub Frequency


  'Go to Sub Inductance to calculate inductance
   If Lc_mode = 0 Then
      Gosub Inductance

   Else
      'Go to Sub Capacitance to calculate capacitance
      Gosub Capacitance
   End If

     Gosub Displaying

     Gosub Timers_reset


   Return

'End of program
'************************************